/********************************************************************************/
/*																				*/
/*	Kroenke, Auer, Vandeberg, and Yoder 				*/
/*	Database Concepts (8th Edition) Chapters 06, 07, 08		*/
/*																				*/
/*	Marcia's Dry Cleaning Project Insert Data 									*/
/*																				*/
/*	Microsoft SQL Server 2016 code solutions								*/
/*																				*/
/********************************************************************************/


USE MDC
GO

/*****   Case Question  7.E   ***************************************************/

ALTER TABLE INVOICE 
	ADD	Status		Char(12)	NULL;

ALTER TABLE INVOICE 
	ADD	CONSTRAINT	StatusValueCheck	CHECK
		(Status IN ('Waiting', 'In-process', 'Finished', 'Pending'));

UPDATE INVOICE
	SET  	Status = 'Finished'
	WHERE	DateOut IS NOT NULL;

UPDATE INVOICE
	SET  	Status = 'In-Process'
	WHERE	DateOut IS NULL;

SELECT * FROM INVOICE;

/*****   Project Question  7.F   ************************************************/
/******  Create View  ***********************************************************/

CREATE VIEW 	CustomerInvoiceView AS
	SELECT 		C.LastName, C.FirstName, C.Phone, I.InvoiceNumber,
				I.DateIn, DateOut, I.TotalAmount, I.[Status]
	FROM 		CUSTOMER AS C, INVOICE AS I
	WHERE		C.CustomerID = I.CustomerID;

/******  Query View *************************************************************/

SELECT * FROM CustomerInvoiceView;

/*****   Project Question  8.C   ************************************************/
/******  Insert New Data ********************************************************/
/*  The question suggests adding 11 new invoices, but three more will suffice */

SELECT * FROM INVOICE;

INSERT INTO INVOICE VALUES(
		2017010, 110, '14-Oct-17', NULL, 7.00, 0.55, 7.55, 'In-process');
INSERT INTO INVOICE VALUES(
		2017011, 130, '15-Oct-17', NULL, 140.50, 11.10, 151.60, 'In-process');
INSERT INTO INVOICE VALUES(
		2017012, 120, '17-Oct-17', NULL, 27.00, 2.13, 29.13, 'Waiting');

INSERT INTO INVOICE_ITEM VALUES(2017010, 1, 16, 2,  3.50, 7.00);
INSERT INTO INVOICE_ITEM VALUES(2017011, 1, 16, 3,  3.50, 10.50);
INSERT INTO INVOICE_ITEM VALUES(2017011, 2, 11, 12, 2.50, 30.00);
INSERT INTO INVOICE_ITEM VALUES(2017011, 3, 20, 8,  5.00, 40.00);
INSERT INTO INVOICE_ITEM VALUES(2017011, 4, 25, 10, 6.00, 60.00);
INSERT INTO INVOICE_ITEM VALUES(2017012, 1, 40, 3,  9.00, 27.00);

/******  Query View *************************************************************/

SELECT * FROM CustomerInvoiceView;

/********************************************************************************/













